package com.example.sefinsa_app.utilities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.models.ReporteGeneral;
import com.example.sefinsa_app.ui.reporteGeneral.ReporteGeneralFragment;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;

import java.text.ParseException;
import java.util.ArrayList;

public class ReporteGeneralAdapter extends RecyclerView.Adapter<ReporteGeneralAdapter.ReporteDiarioViewHolder>{

    Context context;
    ArrayList<ReporteGeneral> reporteGeneral;
    private final ReporteGeneralFragment fragment;
    public ReporteGeneralAdapter(Context context, ArrayList<ReporteGeneral> reporteGeneral, ReporteGeneralFragment fragment) {
        this.context = context;
        this.reporteGeneral = reporteGeneral;
        this.fragment = fragment;
    }

    @NonNull
    @Override
    public ReporteGeneralAdapter.ReporteDiarioViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(context).inflate(R.layout.reporte_general_item, parent, false);
        return new ReporteGeneralAdapter.ReporteDiarioViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ReporteGeneralAdapter.ReporteDiarioViewHolder holder, int position) {
        holder.imprimir(position);
    }

    public void clear() {
        reporteGeneral.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<ReporteGeneral> list) {
        reporteGeneral = list;
        notifyDataSetChanged();
    }

    public void setListaFiltrada(ArrayList<ReporteGeneral> filteredList){
        this.reporteGeneral= filteredList;
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        return reporteGeneral.size();
    }

    public class ReporteDiarioViewHolder extends RecyclerView.ViewHolder {

        TextView tvPoblacion, tvFecha, tvCliente, tvFolio, tvConcepto, tvPago, tvMulta, tvPagoColumna;

        Button btnImprimir;

        public ReporteDiarioViewHolder(@NonNull View itemView) {
            super(itemView);

            tvPoblacion = itemView.findViewById(R.id.tvPoblacion);
            tvFecha = itemView.findViewById(R.id.tvFecha);
            tvCliente = itemView.findViewById(R.id.tvCliente);
            tvFolio = itemView.findViewById(R.id.tvFolio);
            tvConcepto = itemView.findViewById(R.id.tvConcepto);
            tvPago = itemView.findViewById(R.id.tvPago);
            tvMulta = itemView.findViewById(R.id.tvMulta);
            btnImprimir = itemView.findViewById(R.id.btnImprimir);

            tvPagoColumna =  ((Activity) context).findViewById(R.id.tvPago);

        }

        public void imprimir(int position) {

            tvPoblacion.setText(reporteGeneral.get(position).getNombre_poblacion());
            tvFecha.setText(reporteGeneral.get(position).getFecha_pago_realizada());
            tvCliente.setText(reporteGeneral.get(position).getNombre_completo());
            tvFolio.setText(reporteGeneral.get(position).getFolio());
            tvConcepto.setText(reporteGeneral.get(position).getConcepto());
            tvPago.setText(reporteGeneral.get(position).getPago());
            tvMulta.setText(reporteGeneral.get(position).getPago_multa());

            btnImprimir.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    AlertDialog.Builder builder6 = new AlertDialog.Builder(context);
                    builder6.setTitle("Seleccionar Opcion")
                            .setPositiveButton("Reimprimir Pago", new DialogInterface.OnClickListener() {
                                @RequiresApi(api = Build.VERSION_CODES.O)
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    //dialog.dismiss();
                                    new MaterialAlertDialogBuilder(context)
                                            .setTitle("Reimprimir pago")
                                            .setMessage("¿Quieres reimprimir el pago de " + reporteGeneral.get(position).getNombre_completo() + "?")
                                            .setPositiveButton("Sí", new DialogInterface.OnClickListener() {
                                                @RequiresApi(api = Build.VERSION_CODES.O)
                                                @Override
                                                public void onClick(DialogInterface dialogInterface, int i) {

                                                    BluetoothUtils.context = context;
                                                    BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);
                                                    try {
                                                        BluetoothUtils.printReimpresion(reporteGeneral.get(position));
                                                    } catch (ParseException e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            })
                                            .setNegativeButton("No", new DialogInterface.OnClickListener() {
                                                @Override
                                                public void onClick(DialogInterface dialogInterface, int i) {

                                                }
                                            })
                                            .show();
                                }
                            })
                            .setNeutralButton("Compartir", new DialogInterface.OnClickListener() {
                                @RequiresApi(api = Build.VERSION_CODES.O)
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    try {
                                        fragment.compartirPagoReporte(reporteGeneral.get(position));
                                    } catch (ParseException e) {
                                        e.printStackTrace();
                                    }
                                }
                            })
                            .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                }
                            })
                            .show();


                }
            });

        }
    }
}
